-- Super Hero Console

-- Console Function
function sh_parse(cmd)

	-- Console Commands List
	if (cmd == adm_cmd[1]) then
		sh_print(2,'====== Console Commands List ======')
		for i = 1,7 do
			sh_print(2,adm_cmd[i]..''..adm_cmd_inf[i])
		end
		return 2
	end
	
	-- Say Commands List
	if (cmd == adm_cmd[2]) then
		sh_print(2,'====== Say Commands List ======')
		for i = 1,10 do
			sh_print(2,say_cmd[i]..' - '..say_cmd_inf[i])
		end
		return 2
	end

	-- Players List
	if (cmd == adm_cmd[3]) then
		sh_print(2,'====== Players List ======')
		for i = 1,pl_count do
			if (player(i,"exists")) then
				if (player(i,"health") > 0) then
					sh_print(2,player(i,"name").." - Level: "..pl_lvl[i].." - Experience: ("..pl_xp[i].."/"..pl_nxp[i]..") - Points: "..pl_pt[i]..' - Credits: '..pl_credits[i])
				else
					sh_print(4,player(i,"name").." (dead) - Level: "..pl_lvl[i].." - Experience: ("..pl_xp[i].."/"..pl_nxp[i]..") - Points: "..pl_pt[i]..' - Credits: '..pl_credits[i])
				end
			end
		end
		return 2
	end

	-- Give Xp
	if (string.sub(cmd, 1, 10) == adm_cmd[4]) then
		local parses = totable(cmd)
		local pl = tonumber(parses[2])
		local xp = tonumber(parses[3])
		if (pl ~= nil) and (xp ~= nil) then
			if (player(pl,"exists")) then
				if (player(pl,"health") > 0) then
					pl_xp[pl] = pl_xp[pl] + xp
					sh_print(2,'You Gave '..xp..' xp for '..player(pl,"name")..'!')
					sh_msg2(pl,2,'Admin Gave You '..xp..' Exp!@C')
					sh_lvl_up(pl)
					sh_txt2(pl,4,1,'Exp: ('..pl_xp[pl]..'/'..pl_nxp[pl]..')',248,430,0)
					sh_pl_save(pl)
				else
					sh_print(4,'You cant give xp for dead player!')
				end
			else
				sh_print(4,'Player does not exist!')
			end
		else
			sh_print(4,'Command dont have right parameters!')
		end
		return 2
	end

	-- Give Lvl
	if (string.sub(cmd, 1, 11) == adm_cmd[5]) then
		local parses = totable(cmd)
		local pl = tonumber(parses[2])
		local lvl = tonumber(parses[3])
		if (pl ~= nil) and (lvl ~= nil) then
			if (player(pl,"exists")) then
				if (player(pl,"health") > 0) then
					for i = 1, lvl do
						if pl_lvl[pl] < sh_lvl_max then
							pl_xp[pl] = pl_xp[pl] + (pl_nxp[pl] - pl_xp[pl])
							sh_lvl_up(pl)
						end
					end
					sh_print(2,'You Gave '..lvl..' lvl for '..player(pl,"name")..'!')
					sh_msg2(pl,2,'Admin Gave You '..lvl..' Level(s)!@C')
					sh_pl_save(pl)
				else
					sh_print(4,'You cant give lvl for dead player!')
				end
			else
				sh_print(4,'Player does not exist!')
			end
		else
			sh_print(4,'Command dont have right parameters!')
		end
		return 2
	end

	-- Max Players
	if (string.sub(cmd, 1, 13) == 'sv_maxplayers') then
		sh_print(4,'You cant change max players in the game!')
		sh_print(4,'Change it before starting server!')
		return 2
	end

	
	-- Give Credits
	if (string.sub(cmd, 1, 15) == adm_cmd[6]) then
		local parses = totable(cmd)
		local pl = tonumber(parses[2])
		local credit = tonumber(parses[3])
		if (pl ~= nil) and (credit ~= nil) then
			if (player(pl,"exists")) then
				if (player(pl,"health") > 0) then
					if pl_credits[pl] < sh_credits_max then
						pl_credits[pl] = pl_credits[pl] + credit
						sh_print(2,'You Gave '..credit..' credits for '..player(pl,"name")..'!')
						sh_msg2(pl,2,'Admin Gave You '..credit..' Credit(s)!@C')
						sh_txt2(pl,6,3,'Credits: ('..pl_credits[pl]..'/'..sh_credits_max..')',210,415,0)
					else
						pl_credits[pl] = sh_credits_max
						sh_txt2(pl,6,3,'Credits: ('..pl_credits[pl]..'/'..sh_credits_max..')',210,415,0)
					end
				else
					sh_print(4,'You cant give credits for dead player!')
				end
			else
				sh_print(4,'Player does not exist!')
			end
		else
			sh_print(4,'Command dont have right parameters!')
		end
		return 2
	end
	-- Give Credits
	if (string.sub(cmd, 1, 19) == adm_cmd[7]) then
		local parses = totable(cmd)
		local crts = tonumber(parses[2])
		if (crts ~= nil) then
			sh_msg(2,'Admin Gave All '..crts..' Credit(s)!@C')
			for i = 1, pl_count do
				if pl_credits[i] < sh_credits_max and player(i,"exists") then
					pl_credits[i] = pl_credits[i] + crts
					sh_txt2(i,6,3,'Credits: ('..pl_credits[i]..'/'..sh_credits_max..')',210,415,0)
				else
					pl_credits[i] = sh_credits_max
					sh_txt2(i,6,3,'Credits: ('..pl_credits[i]..'/'..sh_credits_max..')',210,415,0)
				end
			end
		else
			sh_print(4,'Command dont have right parameters!')
		end
		return 2
	end
	return 0
end